﻿using System.Collections.Generic;
using UnityEngine;

namespace KerbalMass
{
    /// <summary>
    /// This class makes sure that a Kerbal has the mass specified in the settings file.
    /// </summary>
    [KSPAddon(KSPAddon.Startup.Flight, false)]
    public class KerbalMassBehavior : MonoBehaviour
    {
        /// <summary>
        /// Called once when this Behavior is loaded.
        /// Subscribes to EVA event handler.
        /// </summary>
        void Awake()
        {
            GameEvents.onCrewOnEva.Add(ChangeKerbalMass);
        }

        /// <summary>
        /// Changes the mass of an EVAed Kerbal by modifing the value of KerbalEVA.massMultiplier.
        /// </summary>
        /// <param name="action">Parameters provided by event handler</param>
        /// <remarks>It is unknown why Squad calculates a Kerbal's mass by KerbalEVA.initialMass * KerbalEVA.massMultiplier.</remarks>
        private void ChangeKerbalMass(GameEvents.FromToAction<Part,Part> action)
        {
            KerbalEVA evaModule = action.to.Modules["KerbalEVA"] as KerbalEVA;
            evaModule.massMultiplier = KerbalMassConfigManager.Kerbal_Mass / evaModule.initialMass;
        }
    }
}
